---
title: API request · Cloudflare Style Guide
description: required
lastUpdated: 2025-07-09T16:47:26.000Z
chatbotDeprioritize: true
source_url:
  html: https://developers.cloudflare.com/style-guide/components/api-request/
  md: https://developers.cloudflare.com/style-guide/components/api-request/index.md
---

## Import

```mdx
import { APIRequest } from "~/components";
```

## Usage

## `<APIRequest>` Props

### `path`

**required**

**type:** `string`

The path for the API endpoint.

This can be found in our [API documentation](https://api.cloudflare.com), under the name of the endpoint.

### `method`

**required**

**type:** `"GET" | "POST" | "PUT" | "PATCH" | "DELETE" | "HEAD"`

The HTTP method to use.

### `parameters`

**type:** `Record<string, any>`

The parameters to substitute - either in the URL path or as query parameters.

For example, `/zones/{zone_id}/page_shield/scripts` can be transformed into `/zones/123/page_shield/scripts?direction=asc` with the following:

```mdx
parameters={{
  zone_id: "123",
  direction: "asc"
}}
```

If not provided, the component will default to an environment variable. For example, `{setting_id}` will be replaced with `$SETTING_ID`.

### `json`

**type:** `Record<string, any> | Record<string, any>[]`

The JSON payload to send.

If required properties are missing, the component will throw an error.

Functionally, [the `--json` option](https://everything.curl.dev/http/post/json.html) is equivalent to the `--data` option in cURL, but handles a few additional headers automatically.

### `form`

**type:** `Record<string, any>`

The FormData payload to send.

This field is not currently validated against the schema.

### `code`

**type:** `object`

An object of Expressive Code props, the following props are available:

* [Base Props](https://expressive-code.com/key-features/code-component/#available-props)
* [Line Marker Props](https://expressive-code.com/key-features/text-markers/#props)
* [Collapsible Sections Props](https://expressive-code.com/plugins/collapsible-sections/#props)

### `roles`

**type:** `string | boolean`

**default:** `true`

If set to `true`, which is the default, all API token roles will show.

If set to `false`, API token roles will not be displayed.

If set to a string, the API token roles will be filtered using it as a substring (i.e, `roles="domain"` to filter out `Account API Gateway` and only leave `Domain API Gateway`).
